@echo off

setlocal

rem determine this script's directory using a subroutine for reading %~dp0
rem see https://stackoverflow.com/questions/19781569/cmd-failure-of-d0-when-call-quotes-the-name-of-the-batch-file
call :set_script_dir

rem error out if in the root directory
for %%F in ("%script_dir%") do (
  if "%%~pF" == "\" (
    echo ^'%0^' must not be placed in root directory >&2
    exit /b 1
  )
)

rem strip trailing backslash from script_dir
set script_dir=%script_dir:~0,-1%

rem determine deployment directory (script_dir's parent) including 
rem its trailing backslash
for %%F in ("%script_dir%") do ( 
  set deploy_dir=%%~dpF
)

rem path to with_dll_dir utility
set with_dll_dir=%deploy_dir%libexec\usp-python-apps\with_dll_dir

rem dll directory
set dll_dir=%deploy_dir%bin

rem path to target python script
set target_script=%deploy_dir%libexec\usp-python-apps\manifest_edit\manifest_edit_cmd.py

rem if USP_SHOW_WRAPPER is non-empty show what would be executed
if not "%USP_SHOW_WRAPPER%" == "" (
  echo "python" "%with_dll_dir%" "%dll_dir%" "%target_script%" %*
  exit /b 0
)

rem execute target script via with_dll_dir
"python" "%with_dll_dir%" "%dll_dir%" "%target_script%" %*
exit /b %ERRORLEVEL%

rem subroutine for reading %~dp0
:set_script_dir
set script_dir=%~dp0
goto :EOF
