from manifest_edit.plugin.mpd import BasePlugin
from schema import Schema
from manifest_edit.context import Context
from copy import deepcopy


class Plugin(BasePlugin):
    """
    single_to_multi_period plugin.

    Doesn't require any user configuration
    """

    _name = __name__

    def schema(self):
        return Schema({})

    def process(self, manifest, storage):
        Context.log_trace(
            'Just duplicating the period'
        )

        manifest.periods.append(deepcopy(manifest.periods[0]))
