from manifest_edit.plugin.m3u8_main import ManifestIteratorPlugin
from schema import Schema


class Plugin(ManifestIteratorPlugin):
    '''A plugin that can change a generic property
    '''

    _name = __name__

    def schema(self):
        return Schema(
            {
                str: str,
            }
        )

    def process(self, manifest, storage):
        for config_node, element in self.config(manifest, storage):
            for k, v in config_node.items():
                # Well, this is just an ambitious attempt for the moment.
                # In order for this to be really generic, the setByTag should
                # accept any possible types of v (strings, integers, ?)
                # and convert it to the right type required by libfmp4.
                # Also, the "set" operation covers just a subset of what is
                # possible/required, i.e. for codecs you may want to append
                # or remove or modify in place. So, much more complicated
                # than this and hard to make robust.
                # setByTag eventually invokes setattr on the correct member
                # so we'd have to reimplement either appropriate constructors
                # in C++ or override __set__ ?
                element.setByTag(k, v)
