from manifest_edit.context import Context

def _get_member_by_tag(cls, tag_name):
    try:
        return getattr(cls, cls.TAGS_MAP[tag_name])
    except KeyError:
        Context.log_error(f"No mapping for tag {tag_name} on type {cls}")
    except AttributeError:
        if not hasattr(cls, "TAGS_MAP"):
            Context.log_error(f"No TAGS_MAP provided for type {cls}")
        else:
            Context.log_error(
                f"No attribute {cls.TAGS_MAP[tag_name]} exists for type {cls}"
            )

    return None


def _set_member_by_tag(cls, tag_name, value):
    try:
        return setattr(cls, cls.TAGS_MAP[tag_name], value)
    except KeyError:
        Context.log_error(f"No mapping for tag {tag_name} on type {cls}")
    except AttributeError:
        if not hasattr(cls, "TAGS_MAP"):
            Context.log_error(f"No TAGS_MAP provided for type {cls}")
        else:
            Context.log_error(
                f"No attribute {cls.TAGS_MAP[tag_name]} exists for type {cls}"
            )
