"""
    This is a simple module storing a global instance of ContextClass. It is
    used to hold the (few) globals that may be needed across manifest-edit.
"""
import logging


class ContextClass:
    """
    In particular, ContextClass is used to :

    - provide logging functions that can either point to external ones or be
      simple python prints (to be improved with python logging)
    - store an mp4context. This is optional and only needed in case you need
      to use libfmp4 logging functions
    - store the active pipeline for each format, as set up by the "setup"
      method
    - store the extension set up by the "setup" method (to be removed soon in
      favour of extension taken from manifest type)

    """

    def __init__(self):
        logger = logging.getLogger(__name__)
        self._pipeline = None

        self.log_trace = logger.debug  # No trace level in python logging module
        self.log_debug = logger.debug
        self.log_info = logger.info
        self.log_warning = logger.warning
        self.log_error = logger.error

    @property
    def pipeline(self):
        return self._pipeline

    @pipeline.setter
    def pipeline(self, pipeline):
        self._pipeline = pipeline

Context = ContextClass()
