from manifest_edit.plugin.m3u8_main import ManifestIteratorPlugin
from schema import Schema, Or
from manifest_edit.context import Context
import re


class Plugin(ManifestIteratorPlugin):
    '''A plugin that can change a generic property
    '''

    _name = __name__

    _keys = ['add']

    def schema(self):
        return Schema(
            {
                self._keys[0]: str,
            }
        )

    def process(self, manifest, storage):
        for config_node, element in self.config(manifest, storage):
            for k, v in config_node[self._keys[0]].items():
                element.setByTag(k, v)
                
