"""
manifest-edit.libfmp4

This package provides a python wrapper around libfmp4, a Unified Streaming
proprietary C++/python library to manipulate manifests for DASH and HLS
formats.

manifest-edit.libfmp4 adds some python-specific functionalities to libfmp4,
allowing easier and more intuitive usage. For this reason, you should always
import manifest-edit.libfmp4 instead of libfmp4 directly.

Its main purpose is to allow an easy manifest manipulation that abstracts
from the specific serialization format (XML for DASH, plain text
for HLS) and focuses instead on using native python data types. Serialization
to the appropriate format is delegated to the internals of libfmp4.

The first thing you need to know about manifest-edit.libfmp4 is its case
convention:

 - free functions use lower snake case (e.g. my_function)
 - class names use upper CamelCase convention (e.g. MyClass)
 - class attributes use lower camelCase convention (e.g. myAttribute)

The manifest-edit.libfmp4 root module contains generic types and methods that
can be useful for all kinds of manifest format manipulation.

manifest-edit.libfmp4.mpd contains more specialized functionalities that
are strictly related to .mpd (Dash) format manipulation.

manifest-edit.libfmp4.hls contains more specialized functionalities that
are strictly related to .m3u8 (HLS) format manipulation.
"""
# System-wide libfmp4 import, this is the one coming directly from the
#  python bindings.

# Ignoring "imported but unused" errors from flake8. The intent here is to
# create a wrapper around libfmp4 and use exclusively it in manifest_edit
# and not the original libfmp4. This imports allow to
# perform imports such as "import manifest_edit.libfmp4.EtsiReal".

from . import mpd as mpd  # noqa: F401
from . import hls as hls  # noqa: F401
from libfmp4 import (  # noqa: F401
    version_string,
    product_name,
    Context,
    EtsiReal,
    FractionUint32,
    Url,
    SchemeIdValuePair,
    UInt8Vector,
    StringVector,
    StringPairVector
)
