/*******************************************************************************
 mp4_log.h - libfmp4 logging declarations

 Copyright (C) 2007-2025 CodeShop B.V.
 http://www.code-shop.com

 For licensing see the LICENSE file
******************************************************************************/

#ifndef MP4_LOG_H_AKW
#define MP4_LOG_H_AKW

#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif

// Callback for error logging.
// level is one of FMP4_LOG_DEBUG, FMP4_LOG_WARNING, FMP4_LOG_ERROR.

typedef enum
{
  // error conditions
  FMP4_LOG_ERROR,

  // warning conditions
  FMP4_LOG_WARNING,

  // informational
  FMP4_LOG_INFO,

  // debug-level messages
  FMP4_LOG_DEBUG,

  // debug-level messages
  FMP4_LOG_TRACE

} fmp4_log_level_t;

typedef void (*log_error_callback_t)(void* context, fmp4_log_level_t level,
                                     char const* str, size_t size);

#ifdef __cplusplus
} /* extern C definitions */
#endif

#endif // MP4_LOG_H_AKW

// End Of File

