/*******************************************************************************
 post_handler.h - HTTP utility functions for (streaming) PUT/POST

 Copyright (C) 2015-2025 CodeShop B.V.
 http://www.code-shop.com

 For licensing see the LICENSE file
******************************************************************************/

#ifndef POST_HANDLER_H_AKW
#define POST_HANDLER_H_AKW

#include "mod_streaming_export.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct post_handler_t post_handler_t;

MP4_NODISCARD MP4_DLL_EXPORT
post_handler_t* create_post_handler(mp4_process_context_t* context,
                                    char const* in_url);

// post_handler_insert ingests media data.
//
// [first, last>
// The media data.
//
// result_text
// In case of an error, holds additional information.
//
// Return value:
// 200 OK.
//
// 400 Bad Request
// - Error parsing URL
//
// 403 Forbidden
// - Unable to make file mapping. Most likely cause is that the webserver
//   does not have permission to read/write to the file/directory.
//
// 404 Not Found
// - Stream not found.
//
// 409 Conflict
// - Publishing to a stream which has previously been closed.
//
// 412 Precondition Failed
// - Requested fragment not yet available.
//
// 415 Unsupported Media Type
// - Invalid stream box.
// - Missing tfhd box in media fragment.
// - Missing tfxd box in media fragment.
// - Detected corrupt box in media fragment.
// - Box too large in media fragment.
//
// 500 Internal Server Error
// - Not enough memory.
//

MP4_NODISCARD MP4_DLL_EXPORT
int post_handler_insert(post_handler_t* handler,
                        unsigned char const* first, unsigned char const* last,
                        char* result_text, unsigned int result_size);

MP4_DLL_EXPORT void post_handler_exit(post_handler_t* handler);

#ifdef __cplusplus
} /* extern C definitions */
#endif

#endif // POST_HANDLER_H_AKW

// End Of File
