/*******************************************************************************
 transcode_process.h

 Copyright (C) 2016-2025 CodeShop B.V.
 http://www.code-shop.com

 For licensing see the LICENSE file
*******************************************************************************/

#ifndef TRANSCODE_PROCESS_H_AKW
#define TRANSCODE_PROCESS_H_AKW

#include "mod_streaming_export.h"
#include "streaming_io.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Streaming-based transcoding interface for handling (long-running)
 * POST requests.
 * It expects serialized_pipeline_config to contain a serialized
 * streaming_pipeline_config_t.
 * This function obtains its input by repeatingly calling reader,
 * and reports its output by repeatingly calling writer.
 */
MP4_NODISCARD MP4_DLL_EXPORT
int transcode_process_streaming(mp4_process_context_t* context,
                                char const* serialized_pipeline_config,
                                streaming_reader_t reader, void* reader_arg,
                                streaming_writer_t writer, void* writer_arg);

#ifdef __cplusplus
} /* extern C definitions */
#endif

#endif // TRANSCODE_PROCESS_H_AKW

// End Of File

