/*******************************************************************************
 api_process.h -

 Copyright (C) 2007-2025 CodeShop B.V.
 http://www.code-shop.com

 For licensing see the LICENSE file
******************************************************************************/

#ifndef API_PROCESS_H_AKW
#define API_PROCESS_H_AKW

#include "mod_streaming_export.h"
#include "mp4_error.h"
#include "mp4_log.h"
#include <stddef.h>
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct mp4_process_context_t mp4_process_context_t;

typedef struct post_handler_t post_handler_t;

// push requests: POST, PUT
MP4_NODISCARD MP4_DLL_EXPORT
post_handler_t* create_post_handler_api(mp4_process_context_t* context,
                                        fmp4_http_method_t method,
                                        char const* url,
                                        char const* path_info);

// the entry point for all 'API' functions.
MP4_NODISCARD MP4_DLL_EXPORT
int mp4_channel_api(mp4_process_context_t* context, fmp4_http_method_t method,
                    char const* url, char const* path_info);

// the entry point for all admin 'API' functions.
MP4_NODISCARD MP4_DLL_EXPORT
int mp4_admin_api(mp4_process_context_t* context, fmp4_http_method_t method,
                  char const* url);

// the entry point for all 'API' functions.
MP4_NODISCARD MP4_DLL_EXPORT
int mp4_sitemap_api(mp4_process_context_t* context, fmp4_http_method_t method,
                    char const* url, char const* path_info);


#ifdef __cplusplus
} /* extern C definitions */
#endif

#endif // API_PROCESS_H_AKW

// End Of File

