/*******************************************************************************
 headers_t.h - C API for headers_t

 Copyright (C) 2023-2026 CodeShop B.V.
 http://www.code-shop.com

 For licensing see the LICENSE file
******************************************************************************/

#ifndef HEADERS_T_H_AKW
#define HEADERS_T_H_AKW

#include "mod_streaming_export.h"
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct headers_t headers_t;

MP4_DLL_EXPORT char const* headers_get_content_type(headers_t const* headers);
MP4_DLL_EXPORT char const* headers_get_cache_control(headers_t const* headers);
MP4_DLL_EXPORT char const* headers_get_etag(headers_t const* headers);
MP4_DLL_EXPORT uint64_t headers_get_updated_at(headers_t const* headers);
MP4_DLL_EXPORT uint64_t headers_get_updated_at_experimental(headers_t const* headers);
MP4_DLL_EXPORT uint64_t headers_get_expires_at(headers_t const* headers);
MP4_DLL_EXPORT uint64_t headers_get_sunset_at(headers_t const* headers);
MP4_DLL_EXPORT char const* headers_get_location(headers_t const* headers);
MP4_DLL_EXPORT char const* headers_get_content_id(headers_t const* headers);
MP4_DLL_EXPORT char const* headers_get_cmsd_static(headers_t const* headers);
MP4_DLL_EXPORT char const* headers_get_cmsd_dynamic(headers_t const* headers);
MP4_DLL_EXPORT char const* headers_get_x_usp_header1(headers_t const* headers);
MP4_DLL_EXPORT char const* headers_get_x_usp_header2(headers_t const* headers);
MP4_DLL_EXPORT char const* headers_get_link(headers_t const* headers);

MP4_DLL_EXPORT void headers_set_updated_at(headers_t* headers, uint64_t updated_at);

#ifdef __cplusplus
} /* extern C definitions */
#endif

#endif // HEADERS_T_H_AKW

// End Of File

