/*******************************************************************************
 mp4_error.h -

 Copyright (C) 2011-2026 CodeShop B.V.
 http://www.code-shop.com

 For licensing see the LICENSE file
******************************************************************************/

#ifndef MP4_ERROR_H_AKW
#define MP4_ERROR_H_AKW

#include "mod_streaming_export.h"
#include <inttypes.h>

#ifdef __cplusplus
extern "C" {
#endif

enum fmp4_result
{
  FMP4_OK = 0,
  FMP4_100, // Continue
  FMP4_204, // No content
  FMP4_302, // Found
  FMP4_400, // Bad request
//FMP4_401, // Unauthorized
//FMP4_402, // Payment required
  FMP4_403, // Forbidden
  FMP4_404, // Not found
  FMP4_408, // Request timeout
  FMP4_409, // Conflict
  FMP4_410, // Gone
  FMP4_412, // Precondition failed
  FMP4_415, // Unsupported media type
  FMP4_416, // Range not satisfiable
  FMP4_500, // Internal server error
  FMP4_501, // Not implemented
  FMP4_502, // Bad gateway
  FMP4_503, // Service unavailable 
//FMP4_504, // Gateway timeout
  FMP4_MISSING_PREAMBLE,
  FMP4_MISSING_FTYP,
  FMP4_MISSING_MOOV,
  FMP4_MISSING_TRAK,
  FMP4_MISSING_TREX,
  FMP4_MISSING_MOOF,
  FMP4_MISSING_MFRO,
  FMP4_MISSING_TFRA,
  FMP4_PREMATURE_END_OF_BOX,

  // the mp4 file is missing the 'sidx' box. This error may be returned when
  // creating an MPD from audio/video files and the file is missing the index.
  FMP4_MISSING_SIDX,

  FMP4_MISSING_NAL_SIZE,
  FMP4_INVALID_NAL_SIZE,
  FMP4_MISSING_NAL_DATA,
  FMP4_INVALID_NAL_TRAILING_ZEROES,
  FMP4_INVALID_NAL_EMULATION_PREVENTION,
  FMP4_INVALID_SEI,

  FMP4_CONTENT_KEY_MUST_BE_128_BITS,
  FMP4_ERROR_DECRYPTING_USING_AES_CBC,
  FMP4_ERROR_ENCRYPTING_USING_AES_CBC,
  FMP4_ERROR_DECRYPTING_USING_AES_CTR,
  FMP4_ERROR_ENCRYPTING_USING_AES_CTR,
  FMP4_ERROR_DECRYPTING_USING_AES_ECB,
  FMP4_ERROR_ENCRYPTING_USING_AES_ECB,
  FMP4_ISS_FORBIDDEN,
  FMP4_HLS_FORBIDDEN,
  FMP4_HDS_FORBIDDEN,
  FMP4_MPD_FORBIDDEN,
//  FMP4_INVALID_PACKET_LENGTH,
  FMP4_IO_FILENAME_TOO_LONG, // invalid filename (ie. "/c:/Windows/")
  FMP4_IO_HTTP_ERROR,
  FMP4_IO_NO_SUCH_FILE_OR_DIRECTORY,
  FMP4_IO_NOT_A_DIRECTORY,
  FMP4_IO_PERMISSION_DENIED,
  FMP4_IO_BADF,
  FMP4_IO_SPIPE,
  FMP4_IO_READ_ERROR,
  FMP4_IO_WRITE_ERROR,
  FMP4_IO_TOO_MANY_OPEN_FILES,
  FMP4_MISSING_AUDIO_CODEC_PRIVATE_DATA,
  FMP4_MISSING_DRM_OPTIONS,
  FMP4_MISSING_DRM_OPTIONS_FOR_ISS,
  FMP4_MISSING_DRM_OPTIONS_FOR_HLS,
  FMP4_MISSING_DRM_OPTIONS_FOR_HDS,
  FMP4_MISSING_DRM_OPTIONS_FOR_MPD,
  FMP4_NO_SYNC_SAMPLES,
  FMP4_OUT_OF_MEMORY,
  FMP4_PARSE_ERROR,
  FMP4_STD_EXCEPTION,
  FMP4_UNSUPPORTED_REQUEST_FOR_FILE,

  // An invalid fragment index (0) was specified. The index of a fragment
  // for HLS and HDS always start at 1.
  FMP4_INVALID_MEDIA_SEQUENCE,

  // The requested fragment number is less than the first fragment available
  // in the DVR window.
  FMP4_FRAGMENT_NOT_FOUND,

  // The requested fragment number is larger than the last fragment available
  // in the DVR window.
  FMP4_FRAGMENT_NOT_YET_AVAILABLE,

  // Smooth Streaming
  FMP4_ISS_FRAGMENT_NOT_FOUND,
  FMP4_ISS_FRAGMENT_NOT_YET_AVAILABLE,

  // HTTP Live Streaming
  FMP4_HLS_FRAGMENT_NOT_FOUND,
  FMP4_HLS_FRAGMENT_NOT_YET_AVAILABLE,

  // HTTP Dynamic Streaming
  FMP4_HDS_FRAGMENT_NOT_FOUND,
  FMP4_HDS_FRAGMENT_NOT_YET_AVAILABLE,

  // DASH
  FMP4_MPD_FRAGMENT_NOT_FOUND,
  FMP4_MPD_FRAGMENT_NOT_YET_AVAILABLE,

  // No suitable AES decoder is found for decrypting a fragment.
  FMP4_AES_DECODER_NOT_FOUND,

  // A fragment is encrypted with an unsupported AES mode. E.g. only
  // AES 128-bit CTR is supported for Common Encryption and PIFF.
  FMP4_AES_UNSUPPORTED_MODE,

  // The time range specified by [vbegin,vend> is invalid
  FMP4_INVALID_TIME,

  // The function called is a 'no operation'.
  FMP4_NOP,

  // The callback function returns that it should no longer be called.
  FMP4_STOP,

  // No tracks are listed in the server manifest.
  FMP4_EMPTY_MANIFEST,

  // no media available
  FMP4_EMPTY_TIMELINE,

  // The requested track is not listed in the server manifest (e.g when a given
  // predicate doesn't match any input tracks).
  FMP4_TRACK_NOT_FOUND,

  FMP4_SRT_INVALID_TIMESPEC,
  FMP4_SRT_MISSING_TIMESEPARATOR,

  // Errors originating from the transcode backend of Intel MFX
  FMP4_MFX_ERROR,

  // Errors originating from the transcode backend of FDK AAC
  FMP4_FDK_AAC_ERROR,

  // Errors originating from the samplerate backend
  FMP4_LIBSAMPLERATE_ERROR,

  // Errors originating from the FFmpeg backend
  FMP4_FFMPEG_ERROR,

  // Errors originating from the x264 backend
  FMP4_X264_ERROR,

  // Errors originating from the Irdeto watermark backend
  FMP4_IRWMP_WATERMARK_ERROR,

  // Errors originating from the NETINT backend
  FMP4_NETINT_ERROR,

  // API responses
  FMP4_API_CREATED,
  FMP4_API_BAD_REQUEST,
  FMP4_API_FORBIDDEN,
  FMP4_API_NOT_FOUND,
  FMP4_API_METHOD_NOT_ALLOWED,
  FMP4_API_CONFLICT,
  FMP4_API_REQUEST_ENTITY_TOO_LARGE,
  FMP4_API_REQUEST_URI_TOO_LONG,
  FMP4_API_UNSUPPORTED_MEDIA_TYPE,

  FMP4_LICENSE_ERROR,
  FMP4_LICENSE_EXPIRED,
};
typedef enum fmp4_result fmp4_result;

// Convert the result code to a string
MP4_DLL_EXPORT char const* fmp4_result_to_string(fmp4_result rc);

#ifdef __cplusplus
} /* extern C definitions */
#endif

#endif // MP4_ERROR_H_AKW

// End Of File

