/*******************************************************************************
 mp4_options.h - A library for splitting Quicktime/MPEG4 files.

 Copyright (C) 2011-2026 CodeShop B.V.
 http://www.code-shop.com

 For licensing see the LICENSE file
*******************************************************************************/

#ifndef MP4_OPTIONS_H_AKW
#define MP4_OPTIONS_H_AKW

#include "mod_streaming_export.h"
#include <stddef.h>
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

MP4_DLL_EXPORT int mp4_options_set(mp4_options_t* options,
                                   char const* args_data, size_t args_size);
MP4_DLL_EXPORT char const* mp4_options_get_file(mp4_options_t const* options);

MP4_DLL_EXPORT
uint32_t mp4_options_get_throttle_seconds(mp4_options_t const* options);

MP4_DLL_EXPORT
uint64_t const* mp4_options_get_throttle_offsets(mp4_options_t const* options);

#ifdef __cplusplus
} /* extern C definitions */
#endif

#endif // MP4_OPTIONS_H_AKW

// End Of File

