/*******************************************************************************
 s3_util.h - C wrapper interface to sign S3 requests

 Copyright (C) 2020-2026 CodeShop B.V.
 http://www.code-shop.com

 For licensing see the LICENSE file
******************************************************************************/

#ifndef S3_UTIL_H_AKW
#define S3_UTIL_H_AKW

#include "mod_streaming_export.h"
#include "mp4_log.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef void (*mp4_set_header_t)(void* context,
                                 char const* key,
                                 char const* value);

typedef void (*mp4_set_url_t)(void* context,
                              char const* url);

MP4_NODISCARD MP4_DLL_EXPORT int
mp4_add_s3_authentication(void* context,
                          char const* url,
                          char const* secret_key,
                          char const* access_key,
                          char const* region,
                          char const* security_token,
                          int use_headers,
                          mp4_set_header_t set_header,
                          mp4_set_url_t set_url,
                          char* result_text,
                          unsigned int result_size);

typedef struct s3_credentials_cache_t s3_credentials_cache_t;

MP4_NODISCARD MP4_DLL_EXPORT
s3_credentials_cache_t* s3_credentials_cache_init();

MP4_DLL_EXPORT
void s3_credentials_cache_exit(s3_credentials_cache_t const* cache);

typedef void s3_credentials_callback_t(void* context,
                                       char const* secret_key,
                                       char const* access_key,
                                       char const* security_token);

MP4_NODISCARD MP4_DLL_EXPORT int
s3_credentials_cache_obtain(s3_credentials_cache_t* cache,
                            char const* secret_key,
                            char const* access_key,
                            char const* region,
                            char const* role_arn,
                            char const* role_session_name,
                            unsigned int role_duration,
                            fmp4_log_level_t log_level,
                            log_error_callback_t log_error_callback,
                            void* log_error_context,
                            s3_credentials_callback_t s3_credentials_callback,
                            void* s3_credentials_context,
                            char* result_text,
                            unsigned int result_size);

#ifdef __cplusplus
} /* extern C definitions */
#endif

#endif // S3_UTIL_H_AKW

// End Of File
