/*******************************************************************************
 unified_remix_export.h

 Copyright (C) 2015-2026 CodeShop B.V.
 http://www.code-shop.com

 For licensing see the LICENSE file
******************************************************************************/

#ifndef UNIFIED_REMIX_EXPORT_H_AKW
#define UNIFIED_REMIX_EXPORT_H_AKW

#if defined _WIN32 || defined __CYGWIN__
# define UNIFIED_REMIX_DLL_IMPORT __declspec(dllimport)
# define UNIFIED_REMIX_DLL_EXPORT __declspec(dllexport)
# define UNIFIED_REMIX_DLL_LOCAL
#else
# if __GNUC__ >= 4
#   define UNIFIED_REMIX_DLL_IMPORT __attribute__ ((visibility("default")))
#   define UNIFIED_REMIX_DLL_EXPORT __attribute__ ((visibility("default")))
#   define UNIFIED_REMIX_DLL_LOCAL  __attribute__ ((visibility("hidden")))
# else
#   define UNIFIED_REMIX_DLL_IMPORT
#   define UNIFIED_REMIX_DLL_EXPORT
#   define UNIFIED_REMIX_DLL_LOCAL
# endif
#endif

#if defined(BUILDING_REMIX)
#  if defined(REMIX_STATIC)
#    define REMIX_DLL_EXPORT
#  else
#    define REMIX_DLL_EXPORT UNIFIED_REMIX_DLL_EXPORT
#  endif
#else
#  if defined(REMIX_STATIC)
#    define REMIX_DLL_EXPORT
#  else
#    define REMIX_DLL_EXPORT UNIFIED_REMIX_DLL_IMPORT
#  endif
#endif

#define REMIX_DLL_LOCAL UNIFIED_REMIX_DLL_LOCAL

#ifdef __cplusplus
#define __STDC_FORMAT_MACROS    // C++ should define this for PRIu64
#define __STDC_LIMIT_MACROS     // C++ should define this for UINT64_MAX
#define __STDC_CONSTANT_MACROS  // C++ should define this for INT64_C
#endif

#endif // UNIFIED_REMIX_EXPORT_H_AKW

// End Of File

