/*******************************************************************************
 buckets_t.h - C API for buckets_t

 Copyright (C) 2010-2026 CodeShop B.V.
 http://www.code-shop.com

 For licensing see the LICENSE file
******************************************************************************/

#ifndef BUCKETS_T_H_AKW
#define BUCKETS_T_H_AKW

#include "mod_streaming_export.h"
#include "mp4_error.h"
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct bucket_t bucket_t;

struct buckets_t
{
  // the bucket list that is output
  bucket_t* bucket_;
};
typedef struct buckets_t buckets_t;

MP4_DLL_EXPORT extern char const* cache_control_no_cache;

MP4_DLL_EXPORT void bucket_insert_head(buckets_t* buckets, bucket_t* bucket);
MP4_DLL_EXPORT void bucket_insert_tail(buckets_t* buckets, bucket_t* bucket);

// returns the size of the buckets by accumulating the size of all the buckets.
// If a bucket with unknown length (UINT64_MAX) is encountered, then UINT64_MAX
// is returned.
MP4_NODISCARD MP4_DLL_EXPORT uint64_t buckets_size(buckets_t const* buckets);

// returns the size of the buckets by accumulating the size of all the buckets.
// If a bucket with unknown length (UINT64_MAX) is encountered, a read-ahead
// replaces it by one or more buckets of known size.
MP4_NODISCARD MP4_DLL_EXPORT fmp4_result
buckets_establish_size(buckets_t const* buckets, uint64_t* out_size);

MP4_DLL_EXPORT void buckets_clear(buckets_t* buckets);

MP4_DLL_EXPORT char* file_url_to_path(char* filename);

#ifdef __cplusplus
} /* extern C definitions */
#endif

#endif // BUCKETS_T_H_AKW
