/*******************************************************************************
 moov.h - A library for splitting Quicktime/MPEG4 files.

 Copyright (C) 2007-2026 CodeShop B.V.
 http://www.code-shop.com

 For licensing see the LICENSE file
******************************************************************************/

#ifndef MOOV_H_AKW
#define MOOV_H_AKW

// NOTE: don't include stdio.h (for FILE) or sys/types.h (for off_t).
// nginx redefines _FILE_OFFSET_BITS and off_t will have different sizes
// depending on include order

#include "mod_streaming_export.h"
#include <inttypes.h>

#ifdef __cplusplus
extern "C" {
#endif

struct bucket_t;

/* Returns true when the test string is a prefix of the input */
MP4_DLL_EXPORT
int mp4_starts_with(const char* input, const char* test);

/* Returns true when the test string is a suffix of the input */
MP4_DLL_EXPORT
int mp4_ends_with(const char* input, const char* test);

// MP4_DLL_EXPORT int mp4_path_exists(const char *path);
// MP4_DLL_EXPORT int mp4_is_dir(const char *path);

#ifdef __cplusplus
} /* extern C definitions */
#endif

#endif // MOOV_H_AKW

// End Of File

