/*******************************************************************************
 output_bucket.h - A library for writing memory / file buckets.

 Copyright (C) 2007-2026 CodeShop B.V.
 http://www.code-shop.com

 For licensing see the LICENSE file
******************************************************************************/

/*
 * C-style bucket interface. C++ clients should should use the C++-style
 * interface in output_bucket.hpp.
 */

#ifndef OUTPUT_BUCKET_H_AKW
#define OUTPUT_BUCKET_H_AKW

#include "mod_streaming_export.h"
#include "mp4_error.h"
#include <stddef.h>
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct bucket_t bucket_t;

MP4_DLL_EXPORT uint32_t get_bucket_type(bucket_t const* bucket);
MP4_DLL_EXPORT int is_bucket_type_heap(bucket_t const* bucket);
MP4_DLL_EXPORT int is_bucket_type_file(bucket_t const* bucket);
MP4_DLL_EXPORT int is_bucket_type_http(bucket_t const* bucket);
MP4_DLL_EXPORT int is_bucket_type_xfrm(bucket_t const* bucket);
MP4_DLL_EXPORT int is_bucket_type_iobf(bucket_t const* bucket);
MP4_DLL_EXPORT int is_bucket_type_strm(bucket_t const* bucket);

typedef void (*bucket_log_error_t)(void* context, fmp4_result result,
                                   char const* error);

MP4_NODISCARD MP4_DLL_EXPORT
fmp4_result bucket_read(bucket_t* bucket, uint8_t const** buf, size_t* size,
                        bucket_log_error_t log_error, void* log_context);

MP4_NODISCARD MP4_DLL_EXPORT
fmp4_result bucket_write(bucket_t* bucket, uint8_t** buf, size_t* size);

MP4_NODISCARD MP4_DLL_EXPORT
fmp4_result bucket_split(bucket_t* bucket, uint64_t size);

MP4_NODISCARD MP4_DLL_EXPORT
fmp4_result bucket_copy(bucket_t const* bucket, bucket_t** dst);

MP4_NODISCARD MP4_DLL_EXPORT bucket_t* bucket_next(bucket_t* bucket);

// Returns UINT64_MAX if unknown
MP4_NODISCARD MP4_DLL_EXPORT uint64_t bucket_size(bucket_t const* bucket);

MP4_NODISCARD MP4_DLL_EXPORT
bucket_t* bucket_heap_create(uint8_t const* buf, uint64_t size);

// utility functions

MP4_DLL_EXPORT void bucket_remove(bucket_t* bucket);
MP4_DLL_EXPORT void bucket_delete(bucket_t* bucket);

MP4_NODISCARD MP4_DLL_EXPORT
fmp4_result bucket_file_read(bucket_t* bucket, char const** filename,
                             uint64_t* offset, uint64_t* size,
                             uint32_t max_size);

#ifdef __cplusplus
} /* extern C definitions */
#endif

#endif // OUTPUT_BUCKET_H_AKW

// End Of File

