/*******************************************************************************
 streaming_io.h

 Copyright (C) 2020-2026 CodeShop B.V.
 http://www.code-shop.com

 For licensing see the LICENSE file
*******************************************************************************/

#ifndef STREAMING_IO_H_AKW
#define STREAMING_IO_H_AKW

#ifdef __cplusplus
extern "C" {
#endif

struct buckets_t;

typedef int (*streaming_reader_t)(void* arg, void* buf, int max_bytes);

/*
 * Use the streaming_writer_t and its argument to send buckets to the reply body
 * every time there is data to send. The writer moves the buckets in *output to
 * the reply body. Ownership of the container (that's *output itself) stays with
 * the caller. The writer returns 0 on success, and -1 on failure.
 */
typedef int (*streaming_writer_t)(void* arg, struct buckets_t* output);

#ifdef __cplusplus
} /* extern C definitions */
#endif

#endif // TRANSCODE_H_AKW

// End Of File

